package omq.common.message;

import java.io.Serializable;

public class Request implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6366255840200365083L;

	private String id;
	private String method;
	private boolean async = false;
	private Object[] arguments;

	private transient long timeout;
	private transient int retries;

	public Request() {
	}

	public Request(String id, String method, Object[] arguments) {
		this.id = id;
		this.method = method;
		this.arguments = arguments;
	}

	private Request(String id, String method, boolean async, Object[] arguments) {
		this.id = id;
		this.method = method;
		this.async = async;
		this.arguments = arguments;
	}

	public static Request newSyncRequest(String id, String method, Object[] arguments) {
		return new Request(id, method, false, arguments);
	}

	public static Request newSyncRequest(String id, String method, Object[] arguments, int retries, long timeout) {
		Request req = new Request(id, method, false, arguments);
		req.setRetries(retries);
		req.setTimeout(timeout);
		return req;
	}

	public static Request newAsyncRequest(String id, String method, Object[] arguments) {
		return new Request(id, method, true, arguments);
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public Object[] getArguments() {
		return arguments;
	}

	public void setArguments(Object[] arguments) {
		this.arguments = arguments;
	}

	public boolean isAsync() {
		return async;
	}

	public void setAsync(boolean async) {
		this.async = async;
	}

	public long getTimeout() {
		return timeout;
	}

	public void setTimeout(long timeout) {
		this.timeout = timeout;
	}

	public int getRetries() {
		return retries;
	}

	public void setRetries(int retries) {
		this.retries = retries;
	}

}
