package test2;

import java.util.ArrayList;
import java.util.List;

import omq.common.broker.Broker;

public class CarThread extends Thread {
	private String name;
	private String tfn;
	private Object lock;

	public CarThread(String name, String tfn, Object lock) {
		this.name = name;
		this.tfn = tfn;
		this.lock = lock;
	}

	@Override
	public void run() {
		try {
			Car car = (Car) Broker.lookup(name, Car.class);
			car.setHP(1001);
			car.setPlate("California 125");
			List<Rim> rims = new ArrayList<Rim>();
			rims.add(new Rim("asdf", 17));
			rims.add(new Rim("qwer", 21));
			car.setRims(rims);

			Thread.sleep(1000);
			
			System.out.println("HP -> " + car.getHP());
			System.out.println("Plate -> " + car.getPlate());
			for (Rim r : car.getRims()) {
				System.out.println("Rim -> " + r.getModel() + ", " + r.getInch());
			}

			Mobile mobile = (Mobile) Broker.lookup(tfn, Mobile.class);
			synchronized (lock) {
				lock.wait(2000);
				List<String> messages = mobile.getMessages();
				for (String m : messages) {
					System.out.println("Message -> " + m);
				}
			}

		} catch (Exception e) {

		}
	}
}
