/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;

public class DefaultSerializers {

    public static class TreeMapSerializer
    extends MapSerializer {
        @Override
        public void write(Kryo kryo, Output output, Map map) {
            TreeMap treeMap = (TreeMap)map;
            boolean bl = kryo.setReferences(false);
            kryo.writeClassAndObject(output, treeMap.comparator());
            kryo.setReferences(bl);
            super.write(kryo, output, map);
        }

        @Override
        protected Map create(Kryo kryo, Input input, Class<Map> clazz) {
            return new TreeMap((Comparator)kryo.readClassAndObject(input));
        }

        @Override
        protected Map createCopy(Kryo kryo, Map map) {
            return new TreeMap(((TreeMap)map).comparator());
        }
    }

    public static class CalendarSerializer
    extends Serializer<Calendar> {
        private static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output, Calendar calendar) {
            this.timeZoneSerializer.write(kryo, output, calendar.getTimeZone());
            output.writeLong(calendar.getTimeInMillis(), true);
            output.writeBoolean(calendar.isLenient());
            output.writeInt(calendar.getFirstDayOfWeek(), true);
            output.writeInt(calendar.getMinimalDaysInFirstWeek(), true);
            if (calendar instanceof GregorianCalendar) {
                output.writeLong(((GregorianCalendar)calendar).getGregorianChange().getTime(), false);
            } else {
                output.writeLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input, Class<Calendar> clazz) {
            Calendar calendar = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input, (Class)TimeZone.class));
            calendar.setTimeInMillis(input.readLong(true));
            calendar.setLenient(input.readBoolean());
            calendar.setFirstDayOfWeek(input.readInt(true));
            calendar.setMinimalDaysInFirstWeek(input.readInt(true));
            long l = input.readLong(false);
            if (l != -12219292800000L && calendar instanceof GregorianCalendar) {
                ((GregorianCalendar)calendar).setGregorianChange(new Date(l));
            }
            return calendar;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar calendar) {
            return (Calendar)calendar.clone();
        }
    }

    public static class TimeZoneSerializer
    extends Serializer<TimeZone> {
        public TimeZoneSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, TimeZone timeZone) {
            output.writeString(timeZone.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input, Class<TimeZone> clazz) {
            return TimeZone.getTimeZone(input.readString());
        }
    }

    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        public CollectionsSingletonSetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Set set) {
            kryo.writeClassAndObject(output, set.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input, Class clazz) {
            return Collections.singleton(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        public CollectionsSingletonMapSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Map map) {
            Map.Entry entry = map.entrySet().iterator().next();
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input, Class clazz) {
            Object object = kryo.readClassAndObject(input);
            Object object2 = kryo.readClassAndObject(input);
            return Collections.singletonMap(object, object2);
        }
    }

    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        public CollectionsSingletonListSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, List list) {
            kryo.writeClassAndObject(output, list.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input, Class clazz) {
            return Collections.singletonList(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends Serializer {
        public CollectionsEmptySetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends Serializer {
        public CollectionsEmptyMapSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends Serializer {
        public CollectionsEmptyListSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class clazz) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output, KryoSerializable kryoSerializable) {
            kryoSerializable.write(kryo, output);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input, Class<KryoSerializable> clazz) {
            KryoSerializable kryoSerializable = kryo.newInstance(clazz);
            kryo.reference(kryoSerializable);
            kryoSerializable.read(kryo, input);
            return kryoSerializable;
        }
    }

    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuilder stringBuilder) {
            output.writeString(stringBuilder);
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input, Class<StringBuilder> clazz) {
            return input.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder stringBuilder) {
            return new StringBuilder(stringBuilder);
        }
    }

    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuffer stringBuffer) {
            output.writeString(stringBuffer);
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input, Class<StringBuffer> clazz) {
            String string = input.readString();
            if (string == null) {
                return null;
            }
            return new StringBuffer(string);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer stringBuffer) {
            return new StringBuffer(stringBuffer);
        }
    }

    public static class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Currency currency) {
            output.writeString(currency == null ? null : currency.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input, Class<Currency> clazz) {
            String string = input.readString();
            if (string == null) {
                return null;
            }
            return Currency.getInstance(string);
        }
    }

    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output, EnumSet enumSet) {
            if (enumSet.isEmpty()) {
                throw new KryoException("An empty EnumSet cannot be serialized.");
            }
            Serializer serializer = kryo.writeClass(output, enumSet.iterator().next().getClass()).getSerializer();
            output.writeInt(enumSet.size(), true);
            for (Object e : enumSet) {
                serializer.write(kryo, output, e);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input, Class<EnumSet> clazz) {
            Registration registration = kryo.readClass(input);
            EnumSet enumSet = EnumSet.noneOf(registration.getType());
            Serializer serializer = registration.getSerializer();
            int n = input.readInt(true);
            for (int i = 0; i < n; ++i) {
                enumSet.add(serializer.read(kryo, input, null));
            }
            return enumSet;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet enumSet) {
            return EnumSet.copyOf(enumSet);
        }
    }

    public static class EnumSerializer
    extends Serializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> clazz) {
            this.setImmutable(true);
            this.setAcceptsNull(true);
            this.enumConstants = clazz.getEnumConstants();
            if (this.enumConstants == null) {
                throw new IllegalArgumentException("The type must be an enum: " + clazz);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Enum enum_) {
            if (enum_ == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(enum_.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input, Class<Enum> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            if (--n < 0 || n > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + clazz.getName() + "\": " + n);
            }
            Object object = this.enumConstants[n];
            return (Enum)object;
        }
    }

    public static class DateSerializer
    extends Serializer<Date> {
        @Override
        public void write(Kryo kryo, Output output, Date date) {
            output.writeLong(date.getTime(), true);
        }

        @Override
        public Date read(Kryo kryo, Input input, Class<Date> clazz) {
            return new Date(input.readLong(true));
        }

        @Override
        public Date copy(Kryo kryo, Date date) {
            return new Date(date.getTime());
        }
    }

    public static class ClassSerializer
    extends Serializer<Class> {
        public ClassSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Class clazz) {
            kryo.writeClass(output, clazz);
        }

        @Override
        public Class read(Kryo kryo, Input input, Class<Class> clazz) {
            return kryo.readClass(input).getType();
        }
    }

    public static class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        private BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                output.writeByte((byte)0);
                return;
            }
            BigDecimal bigDecimal2 = bigDecimal;
            this.bigIntegerSerializer.write(kryo, output, bigDecimal2.unscaledValue());
            output.writeInt(bigDecimal2.scale(), false);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input, Class<BigDecimal> clazz) {
            Object object = this.bigIntegerSerializer.read(kryo, input, (Class)null);
            if (object == null) {
                return null;
            }
            int n = input.readInt(false);
            return new BigDecimal((BigInteger)object, n);
        }
    }

    public static class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigInteger bigInteger) {
            if (bigInteger == null) {
                output.writeByte((byte)0);
                return;
            }
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = bigInteger2.toByteArray();
            output.writeInt(byArray.length + 1, true);
            output.writeBytes(byArray);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input, Class<BigInteger> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            byte[] byArray = input.readBytes(n - 1);
            return new BigInteger(byArray);
        }
    }

    public static class StringSerializer
    extends Serializer<String> {
        public StringSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String string) {
            output.writeString(string);
        }

        @Override
        public String read(Kryo kryo, Input input, Class<String> clazz) {
            return input.readString();
        }
    }

    public static class DoubleSerializer
    extends Serializer<Double> {
        public DoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Double d) {
            output.writeDouble(d);
        }

        @Override
        public Double read(Kryo kryo, Input input, Class<Double> clazz) {
            return input.readDouble();
        }
    }

    public static class FloatSerializer
    extends Serializer<Float> {
        public FloatSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Float f) {
            output.writeFloat(f.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input, Class<Float> clazz) {
            return Float.valueOf(input.readFloat());
        }
    }

    public static class LongSerializer
    extends Serializer<Long> {
        public LongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Long l) {
            output.writeLong(l, false);
        }

        @Override
        public Long read(Kryo kryo, Input input, Class<Long> clazz) {
            return input.readLong(false);
        }
    }

    public static class IntSerializer
    extends Serializer<Integer> {
        public IntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Integer n) {
            output.writeInt(n, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input, Class<Integer> clazz) {
            return input.readInt(false);
        }
    }

    public static class ShortSerializer
    extends Serializer<Short> {
        public ShortSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Short s) {
            output.writeShort(s.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input, Class<Short> clazz) {
            return input.readShort();
        }
    }

    public static class CharSerializer
    extends Serializer<Character> {
        public CharSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Character c) {
            output.writeChar(c.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input, Class<Character> clazz) {
            return Character.valueOf(input.readChar());
        }
    }

    public static class ByteSerializer
    extends Serializer<Byte> {
        public ByteSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Byte by) {
            output.writeByte(by);
        }

        @Override
        public Byte read(Kryo kryo, Input input, Class<Byte> clazz) {
            return input.readByte();
        }
    }

    public static class BooleanSerializer
    extends Serializer<Boolean> {
        public BooleanSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Boolean bl) {
            output.writeBoolean(bl);
        }

        @Override
        public Boolean read(Kryo kryo, Input input, Class<Boolean> clazz) {
            return input.readBoolean();
        }
    }
}

