package omq.server;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.QueueingConsumer.Delivery;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class RemoteWrapper {
	private RemoteObject obj;
	private int numThreads;
	private ArrayList<InvocationThread> invocationList;
	private BlockingQueue<Delivery> deliveryQueue;

	public RemoteWrapper(RemoteObject obj, int numThreads) {
		this.obj = obj;
		this.numThreads = numThreads;
		invocationList = new ArrayList<InvocationThread>();
		deliveryQueue = new LinkedBlockingDeque<QueueingConsumer.Delivery>();

		System.out.println("RemoteWrapper -> Object: " + obj.getRef() + ", numthreads listening = " + numThreads);

		for (int i = 0; i < numThreads; i++) {
			InvocationThread thread = new InvocationThread(obj, deliveryQueue);
			invocationList.add(thread);
			thread.start();
		}
	}

	public void notifyDelivery(Delivery delivery) throws Exception {
		this.deliveryQueue.put(delivery);
	}

	public void stopRemoteWrapper() {
		for (InvocationThread thread : invocationList) {
			thread.interrupt();
		}
	}

	public RemoteObject getObj() {
		return obj;
	}

	public void setObj(RemoteObject obj) {
		this.obj = obj;
	}

	public int getNumThreads() {
		return numThreads;
	}

	public void setNumThreads(int numThreads) {
		this.numThreads = numThreads;
	}

	public ArrayList<InvocationThread> getInvocationList() {
		return invocationList;
	}

	public void setInvocationList(ArrayList<InvocationThread> invocationList) {
		this.invocationList = invocationList;
	}

	public BlockingQueue<Delivery> getDeliveryQueue() {
		return deliveryQueue;
	}

	public void setDeliveryQueue(BlockingQueue<Delivery> deliveryQueue) {
		this.deliveryQueue = deliveryQueue;
	}
}
