package test;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import omq.client.annotation.AsyncMethod;
import omq.client.annotation.SyncMethod;
import omq.common.broker.Broker;
import omq.exception.RemoteException;
import omq.server.RemoteObject;

public class ClientImpl extends RemoteObject implements Client {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String id;
	private String profileInfo;
	private Map<String, Client> friendList;

	public ClientImpl(String id, String profileInfo) {
		this.id = id;
		this.profileInfo = profileInfo;
		this.friendList = new HashMap<String, Client>();
	}

	@Override
	@SyncMethod(retry = 1, timeout = 1500)
	public String getID() {
		return id;
	}

	@Override
	@SyncMethod(retry = 1, timeout = 1500)
	public String getProfileInfo() {
		return profileInfo;
	}

	@Override
	@SyncMethod(retry = 1, timeout = 1500)
	public Set<String> getFriends() {
		return friendList.keySet();
	}

	@Override
	@AsyncMethod
	public void sendMessage(String message) {
		System.out.println("" + message);
	}

	@Override
	@AsyncMethod
	public void addContact(String contact) throws RemoteException {
		if (!id.equalsIgnoreCase(contact) && !friendList.containsKey(contact)) {
			Client client = (Client) Broker.lookup(contact, Client.class);
			friendList.put(contact, client);
		}
	}

}
