package multiThreadTest;

import java.util.List;

import omq.Remote;
import omq.client.annotation.AsyncMethod;
import omq.client.annotation.RemoteInterface;
import omq.client.annotation.SyncMethod;
import omq.exception.RemoteException;

@RemoteInterface
public interface Car extends Remote {
	@AsyncMethod
	public void setPlate(String plate);

	@SyncMethod(timeout = 1500)
	public String getPlate();

	@AsyncMethod
	public void setHP(int hp);

	@SyncMethod(timeout = 1500)
	public int getHP();

	@AsyncMethod
	public void setRims(List<Rim> rims);

	@SyncMethod(timeout = 3000)
	public List<Rim> getRims();

	@AsyncMethod
	public void setMobile(String mobile) throws RemoteException;

	@SyncMethod
	public String getMobile();

}
