package calculatorTest;

import java.io.IOException;

import omq.Remote;
import omq.client.annotation.AsyncMethod;
import omq.client.annotation.RemoteInterface;
import omq.client.annotation.SyncMethod;
import omq.exception.SerializerException;

@RemoteInterface
public interface Calculator extends Remote {
	@SyncMethod(timeout = 1500)
	public int add(int x, int y);

	@AsyncMethod
	public void mult(int x, int y);

	@AsyncMethod
	public void sendMessage(Message m);

	@AsyncMethod
	public void asyncDivideByZero() throws IOException, SerializerException;

	@SyncMethod
	public int divideByZero();

}
