package omq.common.broker;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;

import omq.Remote;
import omq.client.annotation.SyncMethod;
import omq.exception.RemoteException;

public interface RemoteBroker extends Remote {
	public Set<String> getRemoteObjects();

	public void spawnObject(String reference, String className, Properties env) throws Exception;

	public void spawnObject(String reference, String className) throws Exception;

	public void deleteObject(String reference) throws RemoteException, IOException;

	@SyncMethod(retry = 1, timeout = 1000)
	public boolean hasObject(String reference);

}
