package omq.test.lock;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class SleepTest {

	@BeforeClass
	public static void Server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		env.setProperty(ParameterQueue.NUM_THREADS, "1");

		for (int i = 0; i < 4; i++) {
			Broker broker = new Broker(env);
			broker.bind("sleep", new SleepImpl());
		}

	}

	@Test
	public void test() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");

		Broker broker = new Broker(env);
		Sleep sleep = broker.lookup("sleep", Sleep.class);

		for (int i = 0; i < 100; i++) {
			sleep.sleep();
		}

		Thread.sleep(100000);
	}

}
