package omq.test.remotePool;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class RemotePoolTest {
	private static String NAME = "remotePool.sleep";

	@BeforeClass
	public static void Server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		env.setProperty(ParameterQueue.MIN_POOL_THREADS, "1");
		env.setProperty(ParameterQueue.MAX_POOL_THREADS, "4");
		env.setProperty(ParameterQueue.POOL_REFRESH_TIME, "1000");
		env.setProperty(ParameterQueue.KEEP_ALIVE_TIME, "2000");
		env.setProperty(ParameterQueue.MAX_MESSAGES_PER_THREAD, "2");

		Broker broker = new Broker(env);

		SleepImpl sleep = new SleepImpl();
		broker.bind(NAME, sleep);
	}

	@Test
	public void test() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");

		Broker broker = new Broker(env);
		Sleep sleep = broker.lookup(NAME, Sleep.class);
		for (int j = 0; j < 2; j++) {

			for (int i = 0; i < 4; i++) {
				sleep.sleep();
			}
			Thread.sleep(3000);
			for (int i = 0; i < 4; i++) {
				sleep.sleep();
			}
			Thread.sleep(10000);
		}
		Thread.sleep(20000 * 1000);
	}
}
