package test.multi;

import static org.junit.Assert.assertEquals;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class BeerTest {

	private static Broker broker;
	private static ClientBeer beer;

	@BeforeClass
	public static void server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		
		Broker b1 = new Broker(env);
		Broker b2 = new Broker(env);
		
		b1.bind("beer", new BeerImpl());
		b2.bind("beer", new BeerImpl());
		System.out.println("Server started");
	}
	
	
	@Test
	public void test() throws Exception{
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		broker = new Broker(env);
		beer = broker.lookup("beer", ClientBeer.class);
		
		beer.setCl(25);
		Thread.sleep(500);
		beer.setCl(33);
		Thread.sleep(500);
		assertEquals(2, beer.getCl().length);
	}
}
