package test.queues;

import static org.junit.Assert.assertEquals;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class BeerTest {

	private static Broker broker;

	@BeforeClass
	public static void server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");

		Broker b1 = new Broker(env);
		Broker b2 = new Broker(env);

		b1.bind("beer", "beer1", new BeerImpl());
		b2.bind("beer", "beer2", new BeerImpl());
		System.out.println("Server started");
	}

	@Test
	public void test() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		broker = new Broker(env);
		Beer beer1 = broker.lookup("beer", Beer.class);
		beer1.setUID("beer1");
		Beer beer2 = broker.lookup("beer", Beer.class);
		beer2.setUID("beer2");
		
		beer1.setCl(25);
		beer2.setCl(33);

		Thread.sleep(500);

		assertEquals(25, beer1.getCl());
		assertEquals(33, beer2.getCl());
		// Thread.sleep(500000);

	}
}
