package omq.test.multiThread2;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.supervisor.Sleep;
import omq.test.supervisor.SleepImpl;

import org.junit.BeforeClass;
import org.junit.Test;

public class MultiThreadTest {
	@BeforeClass
	public static void Server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		env.setProperty(ParameterQueue.MIN_POOL_THREADS, "4");
		env.setProperty(ParameterQueue.MAX_POOL_THREADS, "4");
		SleepImpl sleep = new SleepImpl();

		Broker broker = new Broker(env);
		broker.bind("sleep", sleep);

	}

	@Test
	public void test() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");

		Broker broker = new Broker(env);
		Sleep sleep = broker.lookup("sleep", Sleep.class);

		for (int i = 0; i < 10; i++) {
			sleep.sleep();
		}

		Thread.sleep(10000);
	}

}
