package omq.common.broker;

import omq.Remote;
import omq.client.annotation.MultiMethod;
import omq.client.annotation.SyncMethod;
import omq.exception.RetryException;

public interface RemoteMultiBroker extends Remote {

	@MultiMethod
	@SyncMethod(retry = 1, timeout = 1000)
	public boolean[] hasObject(String reference) throws RetryException;

	@MultiMethod
	@SyncMethod(retry = 1, timeout = 1000)
	public HasObject[] hasObjectInfo(String reference) throws RetryException;

}
