package test.multiBroker;

import static org.junit.Assert.assertEquals;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.broker.RemoteBroker;
import omq.common.broker.RemoteBrokerImpl;
import omq.common.broker.RemoteMultiBroker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class MultiBrokerTest {

	private static Broker broker;
	private static RemoteMultiBroker multiBroker;
	private static RemoteBroker brokerProxy;

	@BeforeClass
	public static void server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		env.setProperty(ParameterQueue.MIN_POOL_THREADS, "1");
		env.setProperty(ParameterQueue.MAX_POOL_THREADS, "1");
		
		Broker b1 = new Broker(env);
		Broker b2 = new Broker(env);
		
		b1.bind("broker", "broker1", new RemoteBrokerImpl());
		b2.bind("broker", "broker2", new RemoteBrokerImpl());
		System.out.println("Server started");
	}
	
	
	@Test
	public void test() throws Exception{
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		broker = new Broker(env);
		multiBroker = broker.lookup("broker", RemoteMultiBroker.class);
//		brokerProxy = broker.lookup("broker", RemoteBroker.class);
		
		assertEquals(2, multiBroker.hasObjectInfo("hola").length);
	}
}
