/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateSerializer
extends Serializer {
    private final Serializer serializer;
    private boolean noHeaders = true;
    private int compressionLevel = 4;

    public DeflateSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void write(Kryo kryo, Output output, Object object) {
        Deflater deflater = new Deflater(this.compressionLevel, this.noHeaders);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)output, deflater);
        Output output2 = new Output(deflaterOutputStream, 256);
        kryo.writeObject(output2, object, this.serializer);
        output2.flush();
        try {
            deflaterOutputStream.finish();
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
    }

    public Object read(Kryo kryo, Input input, Class clazz) {
        Inflater inflater = new Inflater(this.noHeaders);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(input, inflater);
        return kryo.readObject(new Input(inflaterInputStream, 256), clazz, this.serializer);
    }

    public void setNoHeaders(boolean bl) {
        this.noHeaders = bl;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = n;
    }

    public Object copy(Kryo kryo, Object object) {
        return this.serializer.copy(kryo, object);
    }
}

