package farmTest;

import static org.junit.Assert.assertEquals;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class FarmTest {
	private static FarmImpl farm;
	private static Farm remoteFarm;

	@BeforeClass
	public static void startServer() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");

		// Get info about the queue & the exchange where the RemoteListener will
		// listen to.
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");

		farm = new FarmImpl();

		Broker.initBroker(env);
		Broker.bind(Farm.class.getSimpleName(), farm);
	}

	@BeforeClass
	public static void startClient() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");

		// Set info about the queue & the exchange where the ResponseListener
		// will listen to.
		env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
		env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");

		Broker.initBroker(env);

		remoteFarm = (Farm) Broker.lookup(Farm.class.getSimpleName(), Farm.class);
	}

	@Test
	public void addCow() throws Exception {
		String name = "muu";

		Cow cow = new Cow();
		cow.setName(name);

		remoteFarm.setCow(cow);
		Thread.sleep(100);

		assertEquals(name, farm.getCow().getName());
	}

	@Test
	public void getPig() throws Exception {
		String name = "oing";

		Pig pig = new Pig();
		pig.setName(name);

		remoteFarm.setPig(pig);
		Thread.sleep(100);

		pig = remoteFarm.getPig();

		assertEquals(name, pig.getName());
	}
}
