package omq.test.temporal;

import java.util.Set;

import omq.Remote;
import omq.client.annotation.AsyncMethod;
import omq.client.annotation.RemoteInterface;
import omq.client.annotation.SyncMethod;
import omq.exception.RemoteException;

@RemoteInterface
public interface Client extends Remote {

	@SyncMethod(retry = 1, timeout = 1500)
	public String getID();

	@SyncMethod(retry = 1, timeout = 1500)
	public String getProfileInfo();

	@SyncMethod(retry = 1, timeout = 1500)
	public Set<String> getFriends();

	@AsyncMethod
	public void sendMessage(String message);

	@AsyncMethod
	public void addContact(String contact) throws RemoteException;
}
