package omq.test.multiThread;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

public class ClientTest {

	public static void main(String[] args) throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");
		// env.setProperty(ParameterQueue.SERIALIZERNAME,
		// "omq.common.util.Serializers.GsonImp");
		env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
		// Set info about the queue & the exchange where the ResponseListener
		// will listen to.
		env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
		env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");

		Broker.initBroker(env);

		String car = "audi";
		String tfn = "aifon";
		Object lock = new Object();
		CarThread t1 = new CarThread(car, tfn, lock);
		MobileThread t2 = new MobileThread(tfn, lock);

		t1.start();
		t2.start();
		
	}
}
