package omq.common.util;

import java.util.Properties;

import omq.exception.EnvironmentException;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class Environment {
	private static Properties env;

	/**
	 * This method return the environment of the middleware
	 * 
	 * @return Environment to use in the middleware
	 * @throws EnvironmentException
	 *             will be thrown whether the environment is null
	 */
	public static Properties getEnvironment() throws EnvironmentException {
		if (env == null) {
			throw new EnvironmentException();
		}
		return env;
	}

	/**
	 * This method sets the environment of the middleware
	 * 
	 * @param environment
	 */
	public static void setEnvironment(Properties environment) {
		env = environment;
	}
}
