package omq.common.util;

import java.io.IOException;
import java.util.Properties;

import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.Serializers.ISerializer;
import omq.exception.EnvironmentException;
import omq.exception.SerializerException;
import omq.server.remote.request.RemoteObject;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class Serializer {
	public static ISerializer serializer;

	private static Boolean getEnableCompression(){
		Boolean enableCompression = false;
		try {
			Properties env = Environment.getEnvironment();
			enableCompression = Boolean.valueOf(env.getProperty(ParameterQueue.ENABLECOMPRESSION, "false"));
		} catch (EnvironmentException e) { }
		
		return enableCompression;
	}
	
	public static ISerializer getInstance() throws SerializerException {		
		if (serializer == null) {
			try{
				Properties env = Environment.getEnvironment();				
				String className = env.getProperty(ParameterQueue.SERIALIZERNAME, "omq.common.util.Serializers.JavaImp");
				
				serializer = (ISerializer) Class.forName(className).newInstance();
			} catch (Exception ex){
				throw new SerializerException(ex.getMessage(), ex);
			}
		}
		
		return serializer;
	}

	public static byte[] serialize(Object obj) throws SerializerException {
		ISerializer instance = getInstance();
		
		Boolean enableCompression = getEnableCompression();		
		if(enableCompression){
			byte[] objSerialized = instance.serialize(obj);
			try {
				return Zipper.zip(objSerialized);
			} catch (IOException e) {
				throw new SerializerException(e.getMessage(), e);
			}			
		} else{
			return instance.serialize(obj);
		}		
	}

	public static Request deserializeRequest(byte[] bytes, RemoteObject obj) throws SerializerException {
		ISerializer instance = getInstance();
				
		Boolean enableCompression = getEnableCompression();
		if(enableCompression){
			try {
				byte[] unZippedBytes = Zipper.unzip(bytes);
				return instance.deserializeRequest(unZippedBytes, obj);
			} catch (IOException e) {
				throw new SerializerException(e.getMessage(), e);
			}
		} else{
			return instance.deserializeRequest(bytes, obj);
		}			
	}

	public static Response deserializeResponse(byte[] bytes, Class<?> type) throws SerializerException {
		ISerializer instance = getInstance();
		
		Boolean enableCompression = getEnableCompression();
		if(enableCompression){
			try {
				byte[] unZippedBytes = Zipper.unzip(bytes);
				return instance.deserializeResponse(unZippedBytes, type);
			} catch (IOException e) {
				throw new SerializerException(e.getMessage(), e);
			}
		} else{
			return instance.deserializeResponse(bytes, type);
		}			
	}
}