package omq.ztest.calculator;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

public class ServerTest {
	private static CalculatorImpl calc;
	private static CalculatorImpl calc2;

	public static void main(String[] args) throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");
		// env.setProperty(ParameterQueue.SERIALIZERNAME,
		// "omq.common.util.Serializers.KryoImp");
		env.setProperty(ParameterQueue.SERIALIZERNAME, "omq.common.util.Serializers.GsonImp");
		env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");

		calc = new CalculatorImpl();
		calc2 = new CalculatorImpl();

		Broker.initBroker(env);
		Broker.bind("calculator1", calc);
		Broker.bind("calculator2", calc2);

		System.out.println("Server started");
	}
}
