package omq.common.util;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class ParameterQueue {

	/*
	 * Properties environment
	 */

	public static String SERIALIZER_NAME = "omq.serializer";

	/**
	 * Set whether the messages must be compressed or not
	 */
	public static String ENABLECOMPRESSION = "omq.compression";

	/**
	 * Set the ip where the rabbitmq server is.
	 */
	public static String SERVER_HOST = "omq.host";

	/**
	 * Set the port that rabbitmq uses.
	 */
	public static String SERVER_PORT = "omq.port";

	/**
	 * Set the clients username
	 */
	public static String USER_NAME = "omq.username";

	/**
	 * Set the clients password
	 */
	public static String USER_PASS = "omq.pass";

	/**
	 * Set the exchange where the objectmq are listening
	 */
	public static String RPC_EXCHANGE = "omq.rpc_exchange";

	/**
	 * Set the clients reply queue. Every client must have a different queue
	 * name.
	 */
	public static String RPC_REPLY_QUEUE = "omq.reply_queue_rpc";

	/**
	 * Set the clients event queue. Every client must have a different queue
	 * name.
	 */
	public static String EVENT_REPLY_QUEUE = "omq.reply_queue_event";

	/**
	 * Set if the queues must be durable. The queues won't be lost when rabbitmq
	 * crashes if DURABLE_QUEUES is set trues.
	 */
	public static String DURABLE_QUEUES = "omq.durable_queue";

	/**
	 * The MESSAGE_TTL_IN_QUEUES controls for how long a message published to
	 * the queues can live before it is discarded. A message that has been in
	 * the queue for longer than the configured TTL is said to be dead.
	 * 
	 * This property must be a non-negative 32 bit integer (0 <= n <= 2^32-1),
	 * describing the TTL period in milliseconds.
	 */
	public static String MESSAGE_TTL_IN_QUEUES = "omq.message_ttl_queue";

	// TODO persisten messages? the messages will be saved in the disk if this
	// flag is set true

	public static String ENABLE_SSL = "omq.enable_ssl";
	public static String DEBUGFILE = "omq.debug_file";

	public static String RETRY_TIME_CONNECTION = "omq.retry_connection";

	/*
	 * Values
	 */

	// Change this!!!
	public static String RPC_TYPE = "direct";

	public static String NUM_THREADS = "omq.num_threads";

	public static String REGISTRY_NAME = "REGISTRY";

	/**
	 * Time in milis
	 */
	public static long DEFAULT_TIMEOUT = 1 * 1000 * 60;

}
