package omq.common.event;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * This class implements an Event. It's used to generate events and to indicate
 * some information about how the event was created, when, etc. The events are
 * used to be captured by EventListeners
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
public class Event implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String topic;
	private String corrId;
	private Object obj;
	private String time;

	public Event() { }
	
	/**
	 * Event constructor.
	 * 
	 * @param topic
	 *            Indicates which is the topic of this method
	 * @param corrId
	 *            Indicates what method has created it
	 * @param obj
	 *            Object that's wanted to be sent
	 */
	public Event(String topic, String corrId, Object obj) {
		this.topic = topic;
		this.corrId = corrId;
		this.obj = obj;
		this.time = getCurrentTime();
	}

	/**
	 * Event constructor.
	 * 
	 * @param topic
	 *            Indicates which is the topic of this method
	 * @param obj
	 *            Object that's wanted to be sent
	 */
	public Event(String topic, Object obj) {
		this.topic = topic;
		this.obj = obj;
		this.time = getCurrentTime();
	}

	/**
	 * 
	 * @return currentTime
	 */
	private String getCurrentTime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date date = new Date();
		return sdf.format(date);
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getCorrId() {
		return corrId;
	}

	public void setCorrId(String corrId) {
		this.corrId = corrId;
	}

	public Object getObj() {
		return obj;
	}

	public void setObj(Object obj) {
		this.obj = obj;
	}

	public String getTime() {
		return time;
	}

	public void setTime(String time) {
		this.time = time;
	}
}
