package omq.common.message.response;

import java.io.Serializable;
import java.util.Properties;

/**
 * This class is used to generate the responses that will be sent whenever a
 * synchronous method is called in the server side
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public abstract class Response implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected String proxyUID;

	public Response() { }

	public Response(String proxyUID) {
		this.proxyUID = proxyUID;
	}

	public abstract Object getResp(Properties env) throws Exception;

	public abstract Object getResp() throws Exception;

	public String getProxyUID() {
		return proxyUID;
	}

	public void setProxyUID(String proxyUID) {
		this.proxyUID = proxyUID;
	}

}