package omq.common.registry;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Properties;

import omq.Remote;
import omq.client.proxy.EvoProxy;
import omq.client.remote.response.ResponseListener;
import omq.common.event.EventDispatcher;
import omq.common.event.EventListener;
import omq.common.event.EventTrigger;
import omq.common.util.ParameterQueue;
import omq.exception.RemoteException;
import omq.server.remote.request.RequestListener;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat> 
 *
 */
public class LocateRegistry {
	private static Registry registry;

	private LocateRegistry() {
	}

	/*
	 * Com ha d'anar aquesta merda? Molt bé creo un nou registry impl. Aquest
	 * tindrà un nom prefixat i el registro al request listener pq pugui rebre
	 * requests :O
	 */
	public static Registry createRegistry(Properties env) throws RemoteException {

		Registry reg = null;

		try {
			RequestListener.init(env);
			EventTrigger.initEventTrigger(env);
			reg = new RegistryImpl();
		} catch (Exception ex) {
			throw new RemoteException(ex);
		}

		return reg;
	}

	public static Registry getRegistry(Properties env) throws Exception {
		ResponseListener.init(env);
		EventDispatcher.init(env);

		EvoProxy evoProxy = new EvoProxy(ParameterQueue.REGISTRY_NAME, env);

		registry = (Registry) Proxy.newProxyInstance(Registry.class.getClassLoader(), RegistryImpl.class.getInterfaces(), evoProxy);

		return registry;
	}

	/*
	 * 
	 * TODO canviar això!! en comptes d'anar aquí el lookup podria anar a un
	 * altre lloc :S
	 */
	public static Object lookup(String name, Properties env) throws Exception {
		System.out.println("Antes de hacer lookup");
		Remote obj = (Remote) registry.lookup(name);
		System.out.println("Despues de lookup");
		return obj;
	}

	public static Object lookup(String name, Properties env, ArrayList<EventListener> listeners) throws Exception {
		System.out.println("Antes de hacer lookup");
		Remote obj = (Remote) registry.lookup(name);
		System.out.println("Despues de lookup");
		for (EventListener eventListener : listeners) {
			obj.addListener(eventListener);
		}

		return obj;
	}
}
