package omq.common.registry;

import java.util.Vector;

import omq.Remote;
import omq.exception.RemoteException;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat> 
 *
 */
public interface Registry extends Remote {

	public Remote lookup(String name) throws RemoteException;

	public void bind(String name, Remote obj) throws RemoteException;

	public void unbind(String name) throws RemoteException;

	public void rebind(String name, Remote obj) throws RemoteException;

	public Vector<String> list() throws RemoteException;
}