package omq.common.util;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
@Aspect
public class AspectDeserializer {
 
	private long start = 0;
	
	/* Read as -- do this *before* any *call* to the function
         * *java.io.PrintStream.println* that takes a *String*
         * and returns *void* and the function is not called
	 * within any class under the package net.andrewewhite.aspects
	 */
    @Before("    call(Object revo.common.util.Serializer.deserialize(byte[]))")
    public void beforeSerializeCall(JoinPoint jp) {    	    	
    	start = AspectSerializer.getTime();
    }  
    
    @After("    call(Object revo.common.util.Serializer.deserialize(byte[]))")
    public void afterSerializeCall(JoinPoint jp) {
    	long end = AspectSerializer.getTime();
		long total = end - start;
		
		System.out.println("Deserialize Time: " + total + "ns");    	
    }
}
