package omq.z.sample.calculator;

import java.util.Properties;

import omq.Remote;
import omq.common.registry.LocateRegistry;
import omq.common.registry.Registry;
import omq.common.util.ParameterQueue;


public class Server {
	private static Registry registry;

	public static void startRegistry(Properties env) throws Exception {
		System.out.println("Start registry");
		registry = LocateRegistry.createRegistry(env);
	}

	public static void registerObject(String name, Remote obj) throws Exception {
		System.out.println("Bind the object");
		registry.bind(name, obj);
	}

	public static void main(String[] args) throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");

		// Get info about the queue & the exchange where the RemoteListener will
		// listen to.
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
		env.setProperty(ParameterQueue.RPC_QUEUE, "rpc_queue");
		env.setProperty(ParameterQueue.RPC_ROUTING_KEY, "rpc");

		startRegistry(env);
		registerObject(Calculator.class.getSimpleName(), new CalculatorImpl());

//		Thread.sleep(15000);
//		RequestListener.stopRequestListener();

	}
}
