package omq;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

import omq.common.event.EventListener;
import omq.common.message.response.Response;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public interface Remote extends Serializable {

	/**
	 * Returns the UID of a RemoteObject
	 * 
	 * @return UID
	 */
	public String getRef();

	public void notify(Object obj) throws Exception;

	public Response invokeMethod(String methodName, Vector<Object> args) throws Exception;

	public void addListener(EventListener eventListener) throws Exception;

	public void removeListener(EventListener eventListener) throws Exception;

	public Collection<EventListener> getListeners() throws Exception;
}
