package omq.common.event;

/**
 * Abstract class that enables to create new EventListeners. The eventListeners
 * are done to execute the notifyEvent function.
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public abstract class EventListener {
	private String topic;

	public EventListener() {
		topic = null;
	}

	/**
	 * Constructor. This constructor uses a String to indicate manually which
	 * event we want to receive
	 * 
	 * @param topic
	 */
	public EventListener(String topic) {
		this.topic = topic;
	}

	/**
	 * Whenever this listener it's notified of an event, will execute this
	 * function
	 * 
	 * @param event
	 */
	public abstract void notifyEvent(Event event);

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getTopic() {
		return topic;
	}

}
