package omq.common.message.request;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import omq.Remote;
import omq.common.message.response.Response;


import com.rabbitmq.client.AMQP.BasicProperties;
import com.rabbitmq.client.Channel;

/**
 * Abstract class that indicates the contract to use in the different request
 * types.
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public abstract class Request implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected String uid;
	protected transient String corrId;
	protected String methodName;
	protected Vector<Object> args;

	
	public Request() { }
	
	/**
	 * 
	 * @param uid
	 *            UID of the object we're calling
	 * @param corrId
	 *            Unique identifier of the method we're calling
	 * @param method
	 *            Name method we want to execute
	 * @param args
	 *            method arguments
	 */

	public Request(String uid, String corrId, String methodName, Vector<Object> args) {
		this.uid = uid;
		this.corrId = corrId;
		this.methodName = methodName;
		this.args = args;
	}

	public abstract void invokeRequest(Remote obj, BasicProperties props) throws Exception;

	/**
	 * This method sends a Request to the exchange
	 * 
	 * @param results
	 *            This is the map where you put your results and you notify
	 *            whether a request has done before
	 * @param env
	 *            This is the environment where the information will be sent
	 * @param channel
	 *            This is the channel that has the connection with the exchange
	 * @return The response of this request
	 * @throws Exception
	 */
	public abstract Object publishRequest(Map<String, Response> results, Properties env, Channel channel) throws Exception;

	public String getUid() {
		return uid;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}

	public String getCorrId() {
		return corrId;
	}

	public void setCorrId(String corrId) {
		this.corrId = corrId;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public Vector<Object> getArgs() {
		return args;
	}

	public void setArgs(Vector<Object> args) {
		this.args = args;
	}
}
