package omq.common.message.response;

import java.util.Collection;
import java.util.Properties;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat> 
 *
 */
public class CollectionResponse extends Response {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String collectionType;
	private Collection<Response> collection;

	public CollectionResponse() {
		super();
	}

	public CollectionResponse(String proxyUID, String collectionType, Collection<Response> collection) {
		super(proxyUID);
		this.collectionType = collectionType;
		this.collection = collection;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public Object getResp(Properties env) throws Exception {
		Collection tmp = (Collection) Class.forName(collectionType).newInstance();
		for (Response resp : collection) {
			tmp.add(resp.getResp(env));
		}
		return tmp;
	}

	@Override
	public Object getResp() throws Exception {
		return collection;
	}

	public String getCollectionType() {
		return collectionType;
	}

	public void setCollectionType(String collectionType) {
		this.collectionType = collectionType;
	}

	public Collection<Response> getCollection() {
		return collection;
	}

	public void setCollection(Collection<Response> collection) {
		this.collection = collection;
	}		
	
}
