package omq.common.message.response;

import java.util.Properties;

/**
 * This class it's used to wrap exceptions.
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class ExceptionResponse extends Response {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Throwable exception;

	public ExceptionResponse() {
		super();
	}

	public ExceptionResponse(String proxyUID, Throwable exception) {
		super(proxyUID);
		this.exception = exception;
	}

	/**
	 * Throws a replica of an exception generated in the server side.
	 */
	@Override
	public Object getResp(Properties env) throws Exception {
		throw new Exception(exception);
	}

	@Override
	public Object getResp() throws Exception {
		return exception;
	}

	public Throwable getException() {
		return exception;
	}

	public void setException(Throwable exception) {
		this.exception = exception;
	}
}
