package omq.common.message.response;

import java.util.Properties;

import omq.client.proxy.EvoProxy;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class ProxyResponse extends Response {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String reference;
	private String remoteInterface;

	public ProxyResponse() {
		super();
	}

	public ProxyResponse(String proxyUID, String reference, String remoteInterface) {
		super(proxyUID);
		this.reference = reference;
		this.remoteInterface = remoteInterface;
	}

	@Override
	public Object getResp(Properties env) throws Exception {
		if (!EvoProxy.containsProxy(reference)) {
			Class<?> clazz = Class.forName(remoteInterface);
			EvoProxy evoProxy = new EvoProxy(reference, clazz, env);
			Class<?>[] array = { clazz };
			return EvoProxy.newProxyInstance(clazz.getClassLoader(), array, evoProxy);
		}
		return EvoProxy.getInstance(reference);
	}

	@Override
	public Object getResp() throws Exception {
		return reference;
	}

	public String getReference() {
		return reference;
	}

	public void setReference(String reference) {
		this.reference = reference;
	}

	public String getRemoteInterface() {
		return remoteInterface;
	}

	public void setRemoteInterface(String remoteInterface) {
		this.remoteInterface = remoteInterface;
	}

}
