package omq.common.util.Serializers;

import omq.exception.SerializerException;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

public class XmlImp implements ISerializer {
	private XStream xStream = new XStream(new DomDriver());

	@Override
	public byte[] serialize(Object obj) throws SerializerException {
		try {
			String output = xStream.toXML(obj);
			return output.getBytes();
		} catch (Exception e) {
			throw new SerializerException("Serialize -> " + e.getMessage(), e);
		}
	}

	@Override
	public byte[] serialize(Object obj, Class<?> clazz) throws SerializerException {
		return serialize(obj);
	}	
	
	@Override
	public Object deserialize(byte[] bytes) throws SerializerException {
		try {
			String input = new String(bytes);
			Object object = xStream.fromXML(input);
			return object;
		} catch (Exception e) {
			throw new SerializerException("Deserialize -> " + e.getMessage(), e);
		}
	}

	@Override
	public Object deserialize(byte[] bytes, Class<?> clazz) throws SerializerException {
		return deserialize(bytes);
	}

}
