package omq.z.sample.calculator;

import java.util.Properties;

import omq.common.event.EventListener;
import omq.common.registry.LocateRegistry;
import omq.common.registry.Registry;
import omq.common.util.ParameterQueue;


public class Client {

	public static void main(String[] args) throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
		env.setProperty(ParameterQueue.RPC_ROUTING_KEY, "rpc");

		// Set info about the queue & the exchange where the ResponseListener
		// will listen to.
		env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
		env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");

		/*
		 * 
		 * 
		 * 
		 */

		Registry registry = LocateRegistry.getRegistry(env);

		Calculator remoteCalc = (Calculator) registry.lookup(Calculator.class.getSimpleName());

		EventListener messageListener = new MessageListener();
		EventListener subs = new SubsListener("SUBS");

		remoteCalc.addListener(messageListener);
		remoteCalc.addListener(subs);

		System.out.println("**AsyncMethod printHelloWorld");
		remoteCalc.printHelloWorld("HOlaaaa!!!");

		System.out.println("------------------------------");

		System.out.println("***AsyncMethod Subs");
		try {
			remoteCalc.subs(30, 10);
			System.out.println("------------------------------");

		} catch (Exception e) {
		}

		System.out.println("***SyncMethod inc" + remoteCalc.inc());
		System.out.println("------------------------------");

		System.out.println("***SyncMethod getRef" + remoteCalc.getRef());
		System.out.println("------------------------------");

		System.out.println("***SyncMethod add" + remoteCalc.add(10, 20));

		// Thread.sleep(15000);
		//
		// EventDispatcher.stopEventDispatcher();
		// ResponseListener.stopResponseListner();
	}

}
