/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class HeartbeatSender {
    private final Object monitor = new Object();
    private final FrameHandler frameHandler;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private boolean shutdown = false;
    private volatile long lastActivityTime;

    HeartbeatSender(FrameHandler frameHandler) {
        this.frameHandler = frameHandler;
    }

    public void signalActivity() {
        this.lastActivityTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeartbeat(int heartbeatSeconds) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (heartbeatSeconds > 0) {
                long interval = TimeUnit.SECONDS.toNanos(heartbeatSeconds) / 2L;
                ScheduledExecutorService executor = this.createExecutorIfNecessary();
                HeartbeatRunnable task = new HeartbeatRunnable(interval);
                this.future = executor.scheduleAtFixedRate(task, interval, interval, TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService createExecutorIfNecessary() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
            }
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ScheduledExecutorService executorToShutdown = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (this.executor != null) {
                executorToShutdown = this.executor;
                this.shutdown = true;
                this.executor = null;
            }
        }
        if (executorToShutdown != null) {
            executorToShutdown.shutdown();
        }
    }

    private final class HeartbeatRunnable
    implements Runnable {
        private final long heartbeatNanos;

        private HeartbeatRunnable(long heartbeatNanos) {
            this.heartbeatNanos = heartbeatNanos;
        }

        public void run() {
            try {
                long now = System.nanoTime();
                if (now > HeartbeatSender.this.lastActivityTime + this.heartbeatNanos) {
                    HeartbeatSender.this.frameHandler.writeFrame(new Frame(8, 0));
                    HeartbeatSender.this.frameHandler.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

