package omq.test.exception;

import static org.junit.Assert.assertEquals;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;

import org.junit.BeforeClass;
import org.junit.Test;

public class ClientTest {
	private static ClientInterface client;

	@BeforeClass
	public static void startClient() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");
		env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
		env.setProperty(ParameterQueue.SERIALIZER_NAME, Serializer.kryo);
		env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");

		// Set info about the queue & the exchange where the ResponseListener
		// will listen to.
		env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
		env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");

		Broker.initBroker(env);
		client = (ClientInterface) Broker.lookup("server", ClientInterface.class);
	}

	@Test
	public void addWheels() throws Exception {
		int wheels = 4;
		client.addWheels(wheels);
		Thread.sleep(200);
		int result = client.getWheels();

		assertEquals(wheels, result);
	}

	@Test
	public void addHp() throws Exception {
		int hp = 200;
		client.addHp(hp);
		Thread.sleep(200);
		int result = client.getHp();

		assertEquals(hp, result);
	}

	@Test
	public void addTrailer() throws Exception {
		Trailer t = new Trailer(1200);
		client.addTrailer(t);
		Thread.sleep(200);
	}

	@Test(expected = UndeclaredThrowableException.class)
	// This exception will be caused by java.lang.NoSuchMethodException
	public void getTrailer() throws Exception {
		client.getTrailer();
	}

	@Test
	public void setPrice() throws Exception {
		double price = 4999.99;
		client.setPrice(price);
		Thread.sleep(200);
	}

	@Test(expected = ClassCastException.class)
	public void getPrice() throws Exception {
		client.getPrice();
	}
}
