package omq.test.faultTolerance;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.calculator.CalculatorImpl;

import org.junit.Test;

public class ServerTest {
	private static CalculatorImpl calc;

	@Test
	public void test() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");
		env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
		env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
		env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000");

		calc = new CalculatorImpl();

		Broker.initBroker(env);
		Broker.bind("calculator1", calc);

		System.out.println("Server started");
		
		Thread.sleep(60 * 1000);
	}
}
