package omq.test.multiProcess;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;

import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

@RunWith(value = Parameterized.class)
public class ClientTest {
	// Execute ServerTest.java 2 times before start this test
	public Number remoteNumber;

	public ClientTest(String type) throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");
		env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
		env.setProperty(ParameterQueue.SERIALIZER_NAME, type);
		env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");

		// Set info about the queue & the exchange where the ResponseListener
		// will listen to.
		env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
		env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");

		Broker.initBroker(env);
		remoteNumber = Broker.lookup("number", Number.class);
	}

	@Parameters
	public static Collection<Object[]> data() {
		Object[][] data = new Object[][] { { Serializer.java }, { Serializer.gson }, { Serializer.kryo } };
		return Arrays.asList(data);
	}

	@After
	public void stop() throws Exception {
		Broker.stopBroker();
	}

	@Test
	public void test() {
		int x = 10;
		remoteNumber.setNumber(x);
		int a = remoteNumber.getNumer();
		assertEquals(0, a);
		int b = remoteNumber.getNumer();
		assertEquals(x, b);
		remoteNumber.setNumber(0);
	}

}
