package omq.common.message.response;

import java.util.Properties;

import omq.client.proxy.Proxymq;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class ProxyResponse extends Response {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String reference;
	private String remoteInterface;

	public ProxyResponse() {
		super();
	}

	public ProxyResponse(String proxyUID, String reference, String remoteInterface) {
		super(proxyUID);
		this.reference = reference;
		this.remoteInterface = remoteInterface;
	}

	@Override
	public Object getResp(Properties env) throws Exception {
		if (!Proxymq.containsProxy(reference)) {
			Class<?> clazz = Class.forName(remoteInterface);
			Proxymq evoProxy = new Proxymq(reference, clazz, env);
			Class<?>[] array = { clazz };
			return Proxymq.newProxyInstance(clazz.getClassLoader(), array, evoProxy);
		}
		return Proxymq.getInstance(reference);
	}

	@Override
	public Object getResp() throws Exception {
		return reference;
	}

	public String getReference() {
		return reference;
	}

	public void setReference(String reference) {
		this.reference = reference;
	}

	public String getRemoteInterface() {
		return remoteInterface;
	}

	public void setRemoteInterface(String remoteInterface) {
		this.remoteInterface = remoteInterface;
	}

}
