/*
 * Decompiled with CFR 0.152.
 */
package omq.test.calculator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.test.calculator.Calculator;
import omq.test.calculator.Message;
import omq.test.calculator.ZeroListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClientTest {
    private static Calculator remoteCalc;
    private static Calculator remoteCalc2;

    public ClientTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.SERIALIZER_NAME, type);
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");
        Broker.initBroker(env);
        remoteCalc = Broker.lookup("calculator1", Calculator.class);
        remoteCalc2 = Broker.lookup("calculator2", Calculator.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{Serializer.java}, {Serializer.gson}, {Serializer.kryo}};
        return Arrays.asList(data);
    }

    @After
    public void stop() throws Exception {
        Broker.stopBroker();
    }

    @Test
    public void add() throws Exception {
        int x = 10;
        int y = 20;
        int sync = remoteCalc.add(x, y);
        int sum = x + y;
        Assert.assertEquals((long)sum, (long)sync);
    }

    @Test
    public void add2() throws Exception {
        int x = 10;
        int y = 20;
        int sync = remoteCalc2.add(x, y);
        int sum = x + y;
        Assert.assertEquals((long)sum, (long)sync);
    }

    @Test
    public void mult() throws Exception {
        int x = 5;
        int y = 15;
        remoteCalc.mult(x, y);
        Thread.sleep(200L);
    }

    @Test
    public void notifyEvent() throws Exception {
        ZeroListener zL = new ZeroListener("zero-event");
        remoteCalc.addListener(zL);
        remoteCalc.asyncDivideByZero();
        Thread.sleep(200L);
    }

    @Test
    public void sendMessage() throws Exception {
        Message m = new Message(2334, "Hello objectmq");
        remoteCalc.sendMessage(m);
    }

    @Test(expected=ArithmeticException.class)
    public void divideByZero() {
        remoteCalc.divideByZero();
    }
}

