/*
 * Decompiled with CFR 0.152.
 */
package omq.common.broker;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import omq.Remote;
import omq.client.listener.ResponseListener;
import omq.client.proxy.Proxymq;
import omq.common.event.Event;
import omq.common.event.EventDispatcher;
import omq.common.event.EventWrapper;
import omq.common.util.OmqConnectionFactory;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.exception.InitBrokerException;
import omq.exception.RemoteException;
import omq.exception.SerializerException;
import omq.server.RemoteObject;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Broker {
    private static final Logger logger = Logger.getLogger((String)Broker.class.getName());
    private static Connection connection;
    private static Channel channel;
    private static boolean clientStarted;
    private static boolean connectionClosed;
    private static Properties environment;
    private static Map<String, RemoteObject> remoteObjs;

    public static synchronized void initBroker(Properties env) throws Exception {
        if (environment == null) {
            URL log4jResource = Broker.class.getResource("/log4j.xml");
            DOMConfigurator.configure((URL)log4jResource);
            remoteObjs = new HashMap<String, RemoteObject>();
            environment = env;
            connection = OmqConnectionFactory.getNewConnection(env);
            channel = connection.createChannel();
            Broker.addFaultTolerance();
            try {
                Broker.tryConnection(env);
            }
            catch (Exception e) {
                channel.close();
                connection.close();
                throw new InitBrokerException("The connection didn't work");
            }
        } else {
            logger.error((Object)"Broker is already started");
            throw new InitBrokerException("Broker is already started");
        }
    }

    public static void stopBroker() throws Exception {
        logger.warn((Object)"Stopping broker");
        if (clientStarted) {
            ResponseListener.stopResponseListner();
            EventDispatcher.stopEventDispatcher();
            Proxymq.stopProxy();
        }
        for (String reference : remoteObjs.keySet()) {
            Broker.unbind(reference);
        }
        Broker.closeConnection();
        clientStarted = false;
        connectionClosed = false;
        environment = null;
        remoteObjs = null;
        Serializer.removeSerializers();
    }

    public static Connection getConnection() throws Exception {
        return connection;
    }

    public static void closeConnection() throws IOException {
        logger.warn((Object)"Clossing connection");
        connectionClosed = true;
        connection.close();
        connectionClosed = false;
    }

    public static Channel getChannel() throws Exception {
        return channel;
    }

    public static Channel getNewChannel() throws IOException {
        return connection.createChannel();
    }

    public static <T extends Remote> T lookup(String reference, Class<T> contract) throws RemoteException {
        try {
            if (!clientStarted) {
                Broker.initClient(environment);
                clientStarted = true;
            }
            if (!Proxymq.containsProxy(reference)) {
                Proxymq proxy = new Proxymq(reference, contract, environment);
                Class[] array = new Class[]{contract};
                return (T)((Remote)Proxymq.newProxyInstance(contract.getClassLoader(), array, proxy));
            }
            return (T)((Remote)Proxymq.getInstance(reference));
        }
        catch (Exception e) {
            throw new RemoteException(e);
        }
    }

    public static void bind(String reference, RemoteObject remote) throws RemoteException {
        try {
            remote.startRemoteObject(reference, environment);
            remoteObjs.put(reference, remote);
        }
        catch (Exception e) {
            throw new RemoteException(e);
        }
    }

    public static void unbind(String reference) throws RemoteException, IOException {
        if (!remoteObjs.containsKey(reference)) {
            throw new RemoteException("The object referenced by 'reference' does not exist in the Broker");
        }
        RemoteObject remote = remoteObjs.get(reference);
        remote.kill();
    }

    public void rebind(String name, Remote obj) throws RemoteException {
    }

    private static synchronized void initClient(Properties environment) throws Exception {
        if (ResponseListener.isVoid()) {
            ResponseListener.init(environment);
        }
        if (EventDispatcher.isVoid()) {
            EventDispatcher.init(environment);
        }
    }

    public static void trigger(Event event) throws IOException, SerializerException {
        String UID = event.getTopic();
        EventWrapper wrapper = new EventWrapper(event);
        logger.debug((Object)("EventTrigger fanout exchange: " + UID + " Event topic: " + UID + " Event corrID: " + event.getCorrId()));
        channel.exchangeDeclare(UID, "fanout");
        byte[] bytesResponse = Serializer.serialize(wrapper);
        channel.basicPublish(UID, "", null, bytesResponse);
    }

    public static void tryConnection(Properties env) throws Exception {
        String exchange;
        Channel channel = connection.createChannel();
        String message = "ping";
        String queueName = exchange = env.getProperty(ParameterQueue.USER_NAME) + "ping";
        String routingKey = "routingKey";
        channel.exchangeDeclare(exchange, "direct");
        channel.queueDeclare(queueName, false, false, false, null);
        channel.queueBind(queueName, exchange, routingKey);
        channel.basicPublish(exchange, routingKey, null, message.getBytes());
        QueueingConsumer consumer = new QueueingConsumer(channel);
        channel.basicConsume(queueName, true, (Consumer)consumer);
        QueueingConsumer.Delivery delivery = consumer.nextDelivery(1000L);
        channel.exchangeDelete(exchange);
        channel.queueDelete(queueName);
        channel.close();
        if (!message.equalsIgnoreCase(new String(delivery.getBody()))) {
            throw new IOException("Ping initialitzation has failed");
        }
    }

    private static void addFaultTolerance() {
        connection.addShutdownListener(new ShutdownListener(){

            public void shutdownCompleted(ShutdownSignalException cause) {
                logger.warn((Object)("Shutdown message received. Cause: " + cause.getMessage()));
                if (!connectionClosed) {
                    if (cause.isHardError()) {
                        if (connection.isOpen()) {
                            try {
                                connection.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            connection = OmqConnectionFactory.getNewWorkingConnection(environment);
                            channel = connection.createChannel();
                            Broker.addFaultTolerance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Channel channel = (Channel)cause.getReference();
                        if (channel.isOpen()) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
    }

    public static Properties getEnvironment() {
        return environment;
    }

    static {
        clientStarted = false;
        connectionClosed = false;
        environment = null;
    }
}

