package omq.common.message;

import java.io.Serializable;

public class Request implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6366255840200365083L;

	private String method;
	private Object[] params;
	private String id;
	private boolean async = false;

	private transient boolean multi;
	private transient long timeout;
	private transient int retries;

	public Request() {
	}

	public Request(String id, String method, Object[] params) {
		this.id = id;
		this.method = method;
		this.params = params;
	}

	private Request(String id, String method, boolean async, Object[] params) {
		this.id = id;
		this.method = method;
		this.async = async;
		this.params = params;
	}

	private Request(String id, String method, boolean async, Object[] params, boolean multi) {
		this.id = id;
		this.method = method;
		this.async = async;
		this.params = params;
		this.multi = multi;
	}

	public static Request newSyncRequest(String id, String method, Object[] params) {
		return new Request(id, method, false, params);
	}

	public static Request newSyncRequest(String id, String method, Object[] params, int retries, long timeout, boolean multi) {
		Request req = new Request(id, method, false, params, multi);
		req.setRetries(retries);
		req.setTimeout(timeout);
		return req;
	}

	public static Request newAsyncRequest(String id, String method, Object[] params, boolean multi) {
		return new Request(id, method, true, params, multi);
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public Object[] getParams() {
		return params;
	}

	public void setParams(Object[] params) {
		this.params = params;
	}

	public boolean isAsync() {
		return async;
	}

	public void setAsync(boolean async) {
		this.async = async;
	}

	public long getTimeout() {
		return timeout;
	}

	public void setTimeout(long timeout) {
		this.timeout = timeout;
	}

	public int getRetries() {
		return retries;
	}

	public void setRetries(int retries) {
		this.retries = retries;
	}

	public boolean isMulti() {
		return multi;
	}

	public void setMulti(boolean multi) {
		this.multi = multi;
	}
}
