package omq.common.util;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.After;


/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
@Aspect
public class AspectSerializer {
 
	private long start = 0;
	private int length;	
	
	public static long getTime(){
		return System.nanoTime();
	}
	
	/* Read as -- do this *before* any *call* to the function
         * *java.io.PrintStream.println* that takes a *String*
         * and returns *void* and the function is not called
	 * within any class under the package net.andrewewhite.aspects
	 */
    @Before("    call(byte[] revo.common.util.Serializer.serialize(Object))")
    public void beforeSerializeCall(JoinPoint jp) {    	    	
    	start = getTime();
    	length = 0;
    }
 
   
    @Around("    call(byte[] revo.common.util.Serializer.serialize(Object))")
    public byte[] aroundSerializeCall(ProceedingJoinPoint jp) throws Throwable {
    	byte[] result = (byte[]) jp.proceed();
    	length = result.length;    	
    	return result;
    }
    
    @After("    call(byte[] revo.common.util.Serializer.serialize(Object))")
    public void afterSerializeCall(JoinPoint jp) {
    	long end = getTime();
		long total = end - start;
		
		System.out.println("Serialize Size:" + length + "|Time: " + total + "ns");    	
    }
}
