/*
 * Decompiled with CFR 0.152.
 */
package omq.client.listener;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import omq.client.proxy.Proxymq;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import org.apache.log4j.Logger;

public class ResponseListener
extends Thread {
    private static final Logger logger = Logger.getLogger(ResponseListener.class.getName());
    private static ResponseListener rListener;
    private Channel channel;
    private QueueingConsumer consumer;
    private boolean killed = false;
    private Map<String, Map<String, byte[]>> results;
    private Properties env;

    protected ResponseListener(Properties env) throws Exception {
        this.env = env;
        this.results = new Hashtable<String, Map<String, byte[]>>();
        this.startRPCQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.killed) {
            try {
                Map<String, byte[]> proxyResults;
                QueueingConsumer.Delivery delivery = this.consumer.nextDelivery();
                AMQP.BasicProperties props = delivery.getProperties();
                String uid_request = delivery.getProperties().getCorrelationId();
                logger.debug("Response received -> proxy reference: " + props.getAppId() + ", corrId: " + uid_request);
                Map<String, byte[]> map = proxyResults = this.results.get(props.getAppId());
                synchronized (map) {
                    if (!proxyResults.containsKey(uid_request)) {
                        proxyResults.put(uid_request, delivery.getBody());
                        proxyResults.notifyAll();
                    }
                }
            }
            catch (InterruptedException i) {
                logger.error(i.toString(), i);
            }
            catch (ShutdownSignalException e) {
                logger.error(e.toString(), e);
                try {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                    this.startRPCQueue();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    try {
                        long milis = Long.parseLong(this.env.getProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000"));
                        Thread.sleep(milis);
                    }
                    catch (InterruptedException e2) {
                        logger.error(e2.toString(), e2);
                    }
                }
            }
            catch (ConsumerCancelledException e) {
                logger.error(e.toString(), e);
            }
            catch (Exception e) {
                logger.error(e.toString(), e);
            }
        }
    }

    private void startRPCQueue() throws Exception {
        this.channel = Broker.getNewChannel();
        HashMap<String, Object> args = null;
        String reply_queue = this.env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
        boolean durable = Boolean.parseBoolean(this.env.getProperty(ParameterQueue.DURABLE_QUEUES, "false"));
        int ttl = Integer.parseInt(this.env.getProperty(ParameterQueue.MESSAGE_TTL_IN_QUEUES, "-1"));
        if (ttl > 0) {
            args = new HashMap<String, Object>();
            args.put("x-message-ttl", ttl);
        }
        this.channel.queueDeclare(reply_queue, durable, false, false, args);
        this.consumer = new QueueingConsumer(this.channel);
        this.channel.basicConsume(reply_queue, true, this.consumer);
    }

    public static void init(Properties env) throws Exception {
        if (rListener != null) {
            throw new Exception("Cannot init because it already exists");
        }
        rListener = new ResponseListener(env);
        rListener.start();
    }

    public static ResponseListener getRequestListener(Properties env) throws Exception {
        if (rListener != null) {
            throw new Exception("Cannot init because it already exists");
        }
        rListener = new ResponseListener(env);
        rListener.start();
        return rListener;
    }

    public static boolean isVoid() {
        return rListener == null;
    }

    public static ResponseListener getRequestListener() throws Exception {
        if (rListener == null) {
            throw new Exception("Request listener not initialized");
        }
        return rListener;
    }

    public boolean containsKey(String key) {
        return this.results.containsKey(key);
    }

    public static void stopResponseListner() throws Exception {
        rListener.kill();
        rListener = null;
    }

    public void kill() throws IOException {
        logger.warn("Killing ResponseListener");
        this.interrupt();
        this.killed = true;
        this.channel.close();
    }

    public void registerProxy(Proxymq proxy) {
        if (!this.results.containsKey(proxy.getRef())) {
            this.results.put(proxy.getRef(), proxy.getResults());
        }
    }
}

