package omq.test.calculator;

import java.io.IOException;

import omq.common.broker.Broker;
import omq.exception.SerializerException;
import omq.server.RemoteObject;

public class CalculatorImpl extends RemoteObject implements Calculator {
	private int mult = 0;
	private Broker broker;

	public CalculatorImpl() throws Exception {
		super();
	}

	public CalculatorImpl(Broker broker) throws Exception {
		super();
		this.broker = broker;
	}

	private static final long serialVersionUID = 1L;

	@Override
	public int add(int x, int y) {
		return x + y;
	}

	@Override
	public void mult(int x, int y) {
		mult = x * y;
	}

	public int getMult() {
		return mult;
	}

	public void setMult(int mult) {
		this.mult = mult;
	}

	@Override
	public void asyncDivideByZero() throws IOException, SerializerException {
		ZeroEvent ze = new ZeroEvent("my zero event", "zero-event");
		broker.trigger(ze);
		// notifyEvent(ze);
	}

	@Override
	public void sendMessage(Message m) {
		System.out.println("Code = " + m.getCode());
		System.out.println("Message = " + m.getMessage());
	}

	@Override
	public int divideByZero() {
		int x = 2 / 0;
		return x;
	}

}
