package omq;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;

import omq.common.event.Event;
import omq.common.event.EventListener;
import omq.exception.SerializerException;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public interface Remote extends Serializable {

	/**
	 * Returns the UID of a RemoteObject
	 * 
	 * @return UID
	 */
	public String getRef();

	public void notifyEvent(Event event) throws IOException, SerializerException;

	public void addListener(EventListener<?> eventListener) throws Exception;

	public void removeListener(EventListener<?> eventListener) throws Exception;

	public Collection<EventListener<?>> getListeners() throws Exception;
}
