/*
 * Decompiled with CFR 0.152.
 */
package omq.server;

import com.rabbitmq.client.QueueingConsumer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import omq.server.InvocationThread;
import omq.server.RemoteObject;
import org.apache.log4j.Logger;

public class RemoteWrapper {
    private static final Logger logger = Logger.getLogger(RemoteWrapper.class.getName());
    private RemoteObject obj;
    private int numThreads;
    private ArrayList<InvocationThread> invocationList;
    private BlockingQueue<QueueingConsumer.Delivery> deliveryQueue;

    public RemoteWrapper(RemoteObject obj, int numThreads) {
        this.obj = obj;
        this.numThreads = numThreads;
        this.invocationList = new ArrayList();
        this.deliveryQueue = new LinkedBlockingDeque<QueueingConsumer.Delivery>();
        logger.info("Object reference: " + obj.getRef() + ", numthreads listening = " + numThreads);
        for (int i = 0; i < numThreads; ++i) {
            InvocationThread thread = new InvocationThread(obj, this.deliveryQueue);
            this.invocationList.add(thread);
            thread.start();
        }
    }

    public void notifyDelivery(QueueingConsumer.Delivery delivery) throws Exception {
        this.deliveryQueue.put(delivery);
    }

    public void stopRemoteWrapper() {
        logger.warn("Stopping Invocation threads vinculed to " + this.obj.getRef());
        for (InvocationThread thread : this.invocationList) {
            thread.interrupt();
        }
    }

    public RemoteObject getObj() {
        return this.obj;
    }

    public void setObj(RemoteObject obj) {
        this.obj = obj;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public ArrayList<InvocationThread> getInvocationList() {
        return this.invocationList;
    }

    public void setInvocationList(ArrayList<InvocationThread> invocationList) {
        this.invocationList = invocationList;
    }

    public BlockingQueue<QueueingConsumer.Delivery> getDeliveryQueue() {
        return this.deliveryQueue;
    }

    public void setDeliveryQueue(BlockingQueue<QueueingConsumer.Delivery> deliveryQueue) {
        this.deliveryQueue = deliveryQueue;
    }
}

